local _l_origin_AE_function = ac.getAutoExposure

--[[
local _l_exposure_LUT = {
--          exposure
    {  -90,  0.50   },
    {  -20,  0.50   },
    {  -17,  0.50   },
    {  -14,  0.49   },
    {  -11,  0.47   },
    {   -9,  0.43   },
    {   -6,  0.320   },
    {   -3,  0.150   },
    {   -2,  0.135  },
    {   -1,  0.125  },
    {    0,  0.115  },
    {    1,  0.110  },
    {    2,  0.105  },
    {    3,  0.095  },
    {    6,  0.090  },
    {    9,  0.086  },
    {   12,  0.083  },
    {   17,  0.080  },
    {   23,  0.075  },
    {   35,  0.065  },
    {   45,  0.056  },
    {   60,  0.053  },
    {   75,  0.051  },
    {   90,  0.050  },
}
local _l_Exposure_lut
local _l_ExposureCPP = LUT:new(_l_exposure_LUT)
]]

local _l_overcast_LUT = {
    -- overcast boost
    {  0.0,     0.00  },
    {  0.1,     0.01  },
    {  0.2,     0.02  },
    {  0.3,     0.03  },
    {  0.4,     0.04  },
    {  0.5,     0.05  },
    {  0.6,     0.07  },
    {  0.7,     0.15  },
    {  0.8,     0.35  },
    {  0.9,     0.60  },
    {  1.0,     1.00  },
}
local _l_Overcast_lut
local _l_OvercastCPP = LUT:new(_l_overcast_LUT)



ac.useCubemapBrightnessEstimation()

-- create a simple brightness filter to use it, to countermeasure YEBIS AE
local _l_brightness_filter = ac.ColorCorrectionHsb { hue=0, saturation=1.0, brightness=1.0, keepLuminance=true }
ac.weatherColorCorrections[#ac.weatherColorCorrections + 1] = _l_brightness_filter

local angles = {0,0}
ac.getSunDirectionTo(__PURE__sunDir)
vec32sphereTo(angles, __PURE__sunDir)
local _l_entry_exposure = 0.03 + 0.22*math.saturate(-angles[2]*0.1)


local _l_useCBEEC = 1.0
local _l_exp = _l_entry_exposure
local _l_Aexp = _l_entry_exposure
local _l_new_exp = _l_entry_exposure
local _l_new_calculated_exp = _l_entry_exposure
local _l_bypass_exp = -1
local _l_bypass_exp_mix = 0.0
local _l_CBE_calc = _l_entry_exposure
local _l_CBE_calc_last = _l_entry_exposure
local _l_CBE_target = 1.0
local _l_CBE_sensitivity = 1.0
local _l_exp_min = 0.001
local _l_exp_max = 1.000
local _l_exp_mul = 1.000
local _l_CBE_adaption_speed_LOW = 2.5
local _l_CBE_adaption_speed_HIGH = 2.5
local _l_YEBIS_minimum = 0
local _l_YEBIS_maximum = 2
local _l_YEBIS_adaption_speed_LOW = nil
local _l_YEBIS_adaption_speed_HIGH = nil
local _l_YEBIS_target = _l_entry_exposure
local _l_wp = 1.0
local _l_wp_last = 1.0
local _l_cbe = 20
local _l_cbe_min = 10
local _l_cbe_max = 30


function PURE__use_ExpCalc(b)
    if b then
        _l_useCBEEC = 1.0
    else
        _l_useCBEEC = 0.0
    end
end
function PURE__ExpCalc_used()
    return _l_useCBEEC>0.0
end

function PURE__set_ExpCalc(x)
    local amount = 0.0
    if type(x) == "boolean" then
        if x then
            amount = 1.0
        else
            amount = 0.0
        end
    elseif type(x) == "number" then
        amount = x
    else
        amount = 1.0
    end
    _l_useCBEEC = math.saturate(amount)
end


function PURE__ExpCalc_set_Limits(min, max)
    _l_exp_min = min or 0.001
    _l_exp_max = max or 1.000
end
function PURE__ExpCalc_get_low_Limit()
    return _l_exp_min
end
function PURE__ExpCalc_get_high_Limit()
    return _l_exp_max
end
function PURE__ExpCalc_set_Target(mult)
    _l_CBE_target = mult or 1.0
end
function PURE__ExpCalc_get_Target(mult)
    return _l_CBE_target
end
function PURE__ExpCalc_set_Sensitivity(mult)
    _l_CBE_sensitivity = mult or 1.0
end
function PURE__ExpCalc_get_Sensitivity()
    return _l_CBE_sensitivity
end
function PURE__ExpCalc_set_Multiplier(mult)
    _l_exp_mul = mult or 1.0
end
function PURE__ExpCalc_get_Multiplier()
    return _l_exp_mul
end
function PURE__ExpCalc_set_AdaptionSpeeds(low, high)
    _l_CBE_adaption_speed_LOW = low or 1
    _l_CBE_adaption_speed_HIGH = high or 1
end
function PURE__ExpCalc_get_LowAdaptionSpeeds() return _l_CBE_adaption_speed_LOW end
function PURE__ExpCalc_get_HighAdaptionSpeeds() return _l_CBE_adaption_speed_HIGH end

function PURE__ExpCalc_set_AdaptionSpeeds_YEBIS(low, high)
    _l_YEBIS_adaption_speed_LOW = low or 1
    _l_YEBIS_adaption_speed_HIGH = high or 1
end
function PURE__ExpCalc_get_low_AdaptionSpeed_YEBIS()
    return _l_YEBIS_adaption_speed_LOW
end
function PURE__ExpCalc_get_low_AdaptionSpeed_YEBIS()
    return _l_YEBIS_adaption_speed_HIGH
end

function PURE__ExpCalc_set_BypassExposure(exp, mix)
    _l_bypass_exp = exp or 0.3
    _l_bypass_exp_mix = mix or 1.0
    _l_bypass_exp_mix = math.saturate(_l_bypass_exp_mix)
end
function PURE__ExpCalc_get_BypassExposure()
    return _l_bypass_exp
end
function PURE__ExpCalc_get_BypassExposureMix()
    return _l_bypass_exp_mix
end


function PURE__ExpCalc_get_CBE_min()
    return _l_cbe_min
end
function PURE__ExpCalc_get_CBE_average()
    return _l_cbe
end
function PURE__ExpCalc_get_CBE_max()
    return _l_cbe_max
end

function PURE__ExpCalc_get_CBE_calculated_exposure()
    return _l_CBE_calc
end
function PURE__ExpCalc_get_YEBIS_calculated_exposure(raw)
    if raw then
        return _l_exp
    else
        return _l_Aexp
    end
end
function PURE__ExpCalc_get_final_calculated_exposure()
    return _l_new_calculated_exp
end
function PURE__ExpCalc_get_final_exposure()
    return _l_new_exp
end


function PURE__YEBIS_set_Limits(min, max)
    ac.setAutoExposureLimits(min, max)
    _l_YEBIS_minimum = min or 0.001
    _l_YEBIS_maximum = max or 1.000
end
function PURE__YEBIS_get_low_Limit()
    return _l_YEBIS_minimum
end
function PURE__YEBIS_get_high_Limit()
    return _l_YEBIS_maximum
end

function PURE__YEBIS_set_Target(x)
    _l_YEBIS_target = x
end
function PURE__YEBIS_get_Target()
    return _l_YEBIS_target
end

local _l_world_brightness = 1.0
function PURE__world_brightness()
    return _l_world_brightness
end

local _l_PPoff_target = 1
local _l_world_fog_instance = __PURE__world__fog_get()
local _l_new_filter_brightness = 1.0
local _l_new_world_brightness  = 1.0
local _l_up = vec3(0,1,0)

function __PURE__apply_Exposure(dt)

    -- calculate the main CBE to use with Pure
    _l_cbe      = math.max(0, ac.getCubemapBrightnessEstimationAverage())
    _l_cbe_min  = math.max(0, ac.getCubemapBrightnessEstimationMinimum())
    _l_cbe_max  = math.max(0, ac.getCubemapBrightnessEstimationMaximum())

--ac.debug("CBE avg", _l_cbe)
--ac.debug("CBE min", _l_cbe_min)
--ac.debug("CBE max", _l_cbe_max)

    if __PURE__Clouds__method == 1 then
        local tmp = PURE__2DCLOUDS_get_sky_adaption()
        local tmp_exp = math.lerp(1, math.pow(math.max(0.001, tmp.v), 0.5), from_twilight_compensate(0))
                      --* (math.pow(math.max(0.1, _l_world_fog_instance.scatter_index), 1.5))
        _l_cbe      =  _l_cbe       / tmp_exp
        _l_cbe_min  =  _l_cbe_min   / tmp_exp
        _l_cbe_max  =  _l_cbe_max   / tmp_exp
    end

    if not PURE__getPP_enabled() then
        -- adapt CBE to ppoff
        local mult = 7 / math.pow(math.max(0.01, __PURE__get_config("ppoff.brightness") * 2), 0.525)
        _l_cbe = _l_cbe * mult
        _l_cbe_min = _l_cbe_min * mult
        _l_cbe_max = _l_cbe_max * mult

        _l_PPoff_target = (1 + (1 - math.saturate(_l_cbe*0.5)))
    end

    if ac.setReflectedSkyTweaks~=nil then
        local cfg_refl_sky_lumi = math.max(0.01, __PURE__get_config("reflections.sky.luminance") or 1)
        local cfg_refl_sky_gamma = math.max(0.01, __PURE__get_config("reflections.sky.gamma") or 1)
        
        _l_cbe_max = _l_cbe_max / (cfg_refl_sky_lumi^0.38)  
        _l_cbe = _l_cbe / (cfg_refl_sky_lumi^0.1)

        _l_cbe_max = _l_cbe_max * (cfg_refl_sky_gamma^0.67)
        _l_cbe = _l_cbe * (cfg_refl_sky_gamma^0.25)
    end


    -- the more clouds a sky has, the more white it is, the more the exposure will be leveled down
    local white_sky = 1 + (0.75 * (clouds__get_cloud_coverage())
                           * (1-math.pow(__PURE__badness, 1.0))
                           * from_twilight_compensate(0)
                           -- only use outside
                           * PURE__get_CamOcclusion("camera.occlusion_control.exposure"))
                           -- only use the white sky adaption, if CBE is high
                           * math.lerpInvSat(_l_cbe, 1 * __PURE__sun_lamps_difference, 6 * __PURE__sun_lamps_difference)
    
    _l_cbe      = _l_cbe     / white_sky
    _l_cbe_min  = _l_cbe_min / white_sky
    _l_cbe_max  = _l_cbe_max / white_sky




    __PURE__STATE:setValue("cbe.minimum", _l_cbe_min)
    __PURE__STATE:setValue("cbe.average", _l_cbe)
    __PURE__STATE:setValue("cbe.maximum", _l_cbe_max)


    if _l_useCBEEC>0.0 then

        _l_new_filter_brightness = 1
        _l_new_world_brightness  = 1

        if PURE__getPP_enabled() then
            if ac.getPpAutoExposureEnabled() then
                _l_exp = ac.getAutoExposure()
            else
                _l_exp = ac.getPpTonemapExposure()
            end
            _l_exp = math.max(0.001, _l_exp)
        end

        _l_exp = _l_exp

        _l_cbe = _l_cbe
               / math.max(0.01, __PURE__get_config("reflections.level"))
               / __PURE_WORLD_brightness
               --* (1 - 0.5*Pure_get_CloudShadow()*sun_compensate(0))
        _l_cbe_max = _l_cbe_max
               / math.max(0.01, __PURE__get_config("reflections.level"))
               / __PURE_WORLD_brightness


               --_d(_l_cbe)
               

        -- a little hack/adaption to damp the reaction of the CBE->exposure calculation
        -- If the camera is not realy into something (occlusion in forward direction), then minimum and average values are gained
        -- Do this only for daytimes!
        local cbe_steady_force = from_twilight_compensate(0)
        _l_cbe_max  = math.pow(math.max(0, _l_cbe_max), 0.9)
        -- avarage is gained to 25% of the maximum value 
        _l_cbe      = math.lerp(_l_cbe, _l_cbe_max, ac.getCameraLookOcclusion() * 0.25 * cbe_steady_force)
        _l_cbe      = math.lerp(_l_cbe, _l_cbe_max, 0.5 * math.saturate(1 - 2*ac.getCameraOcclusion(_l_up)))
        -- minimum is gained to 100% of the average value
        _l_cbe_min  = math.lerp(_l_cbe_min, _l_cbe, ac.getCameraLookOcclusion() * cbe_steady_force)
        _l_cbe      = math.pow(math.max(0, _l_cbe), 0.9) 
        _l_cbe_min  = math.pow(math.max(0, _l_cbe_min), 0.9)
       

        -- for realy low values, take the maximum cbe into account
        _l_cbe = math.max(math.lerp(_l_cbe_max, _l_cbe, math.min(1, math.pow(_l_cbe*10, 0.25))), math.min(1, _l_cbe*5))
        _l_CBE_calc = (0.4) / math.max(0.5/_l_exp_max, math.pow(math.max(0, _l_cbe*0.5), 0.4 * (1 + math.lerpInvSat(_l_new_exp, 0.1, 0.01)) * _l_CBE_sensitivity) * (4 + 1*math.lerpInvSat(_l_cbe_min, 0.1, 0.5)))
        _l_CBE_calc = _l_CBE_calc * (1 + (0.34*math.pow(math.lerpInvSat((_l_cbe_min), 1.25, 0.00), 1)*math.lerpInvSat(_l_cbe, 0.1, 0.6)))


        -- lower exposure with extra advanced ambient light (bad weather)
        _l_CBE_calc = _l_CBE_calc * math.max(0.1, 1-0.25*__PURE__ambient_get_extra_adv_boost())

        -- or a sunangle adapted exposure
        --_l_Exposure_lut = _l_ExposureCPP:get()[1] / math.max(0.01, __PURE__sun_lamps_difference)
        _l_CBE_calc = _l_CBE_calc + (0.25*math.max(-0.05, (1-math.pow(math.max(0, _l_cbe), 0.5))) * (1-math.min(1, _l_CBE_sensitivity)))

        _l_CBE_calc = math.clamp(_l_CBE_calc * _l_CBE_target * _l_PPoff_target, _l_exp_min, _l_exp_max)
        
        

        -- smoothen the exposure movement
        if _l_CBE_calc > _l_CBE_calc_last then
            -- react slow in dark scenery
            if _l_CBE_calc_last > 0.5 then
                _l_CBE_calc_last = _l_CBE_calc_last * math.max(0, 1-dt*0.025*_l_CBE_adaption_speed_LOW) + (_l_CBE_calc) * math.min(1, dt*0.025*_l_CBE_adaption_speed_LOW)
            else
                _l_CBE_calc_last = _l_CBE_calc_last * math.max(0, 1-dt*0.1*_l_CBE_adaption_speed_LOW) + (_l_CBE_calc) * math.min(1, dt*0.1*_l_CBE_adaption_speed_LOW)
            end
        else
            -- react fast to bright light
            _l_CBE_calc_last = _l_CBE_calc_last * math.max(0, 1-dt*_l_CBE_adaption_speed_HIGH) + (_l_CBE_calc) * math.min(1, dt*_l_CBE_adaption_speed_HIGH)
        end

        _l_new_exp = math.max(0.001, _l_CBE_calc_last * _l_exp_mul)

        
        -- YEBIS AE speed smoothing
        -- if no YEBIS speeds are set, use the CBE speeds
        local tmpYEBIS_low_speed    = _l_YEBIS_adaption_speed_LOW  or _l_CBE_adaption_speed_LOW
        local tmpYEBIS_high_speed   = _l_YEBIS_adaption_speed_HIGH or _l_CBE_adaption_speed_HIGH

        if _l_exp > _l_Aexp then
            -- react slow in dark scenery
            _l_Aexp = _l_Aexp * math.max(0, 1-dt*tmpYEBIS_low_speed) + (_l_exp) * math.min(1, dt*tmpYEBIS_low_speed)
        else
            -- react fast to bright light
            _l_Aexp = _l_Aexp * math.max(0, 1-dt*tmpYEBIS_high_speed) + (_l_exp) * math.min(1, dt*tmpYEBIS_high_speed)
        end
     
        _l_new_exp = math.lerp(_l_Aexp, _l_new_exp, _l_useCBEEC)
          
        _l_new_calculated_exp = _l_new_exp
        if _l_bypass_exp >= 0 then
            _l_new_exp = math.lerp(_l_new_exp, _l_bypass_exp, _l_bypass_exp_mix)
        end
        _l_new_world_brightness = _l_new_exp
        
        -- neutralize AE and set new exposure
        if PURE__PP__alternative_AE_with_YEBIS_is_used() then
            _l_new_filter_brightness = _l_new_exp / _l_origin_AE_function()
        else
            _l_new_filter_brightness = _l_new_exp / _l_exp
        end
        


        -- initialize the YEBIS AE Target balanced to the final exposure, so it has a working base.
        --ac.setAutoExposureTarget(math.clamp(0.55 - _l_new_exp, 0.01, 0.5) * 0.35)


        -- UI brightness in VR
        local tmpDT = math.min(0.9, dt*5)
        local tmpExp = _l_new_exp
        if PURE__getPP_enabled() then
            tmpExp = math.pow(tmpExp, 1.25)
        else
            tmpExp = math.pow(tmpExp, 0.5)
        end
        _l_wp = 0.25/math.max(0.001, tmpExp)
        _l_wp_last = _l_wp_last * (1-tmpDT) + _l_wp * (tmpDT)
        local tmp_wrp = _l_wp_last * __PURE__get_config("ui.white_reference_point")
        ac.setWhiteReferencePoint(tmp_wrp)
        __PURE__STATE:setValue("ui.white_reference_point", tmp_wrp)
    else
        _l_new_filter_brightness = 1
        _l_new_world_brightness  = 1

        if PURE__getPP_enabled() then
            if ac.getPpAutoExposureEnabled() then
                _l_new_exp = ac.getAutoExposure()
            else
                _l_new_exp = ac.getPpTonemapExposure()
            end
            _l_new_exp = math.max(0.001, _l_new_exp)
        end
    end

    -- This acts as a counterpart to neutralize AE in YEBIS
    -- Its not needed if YEBIS is bypassed!
    if ___PURE___PP___YEBIS___IS___USED___() then
        _l_brightness_filter.brightness = _l_new_filter_brightness
    end
    ----------------------------------------------------------------------

    _l_world_brightness = 1
    if not PURE__getPP_enabled() then
        _l_world_brightness = _l_new_world_brightness * __PURE__get_config("ppoff.brightness")
    end

    ac.setBrightnessMult((_l_world_brightness * __PURE_WORLD_brightness))
    

    -- set the yebis tonemapping exposure to a fixed value, which is compatible with Pure.
    -- Its mainly needed to have correct working glare
    ac.setPpTonemapExposure(_l_new_exp)


    -- Some hacks to adapt exposure for AC --
    if __CSP_version < 3467 then -- 0.2.12p1 and lower
        if __AC_SIM.cameraMode==5 then
            ac.setAutoExposureTarget(_l_YEBIS_target*0.34)
        elseif __AC_SIM.cameraMode==6 and not ac.isInteriorView() then
            ac.setAutoExposureTarget(_l_YEBIS_target*0.85)
        else
            ac.setAutoExposureTarget(_l_YEBIS_target)
        end
    else
        if __AC_SIM.cameraMode==5 or __AC_SIM.cameraMode==6 then
            if ac.isInteriorView() then
                ac.setAutoExposureTarget(_l_YEBIS_target)
            else
                ac.setAutoExposureTarget(_l_YEBIS_target*0.8)
            end
        else
            ac.setAutoExposureTarget(_l_YEBIS_target)
        end
    end

    -- this fixes some bugs with different exposures in different cameras
    --if __CSP_version < 3467 then -- 0.2.12p1 and lower
        ac.setCameraExposure(12)
    --end
end